--
--  Copyright 2011 Autodesk, Inc. All rights reserved.
--
rollout DYNdrapeSpline ""
(
  ---SECTION 1 - SET UP LOCAL VARIABLES---
  local LOCsurface
  local LOCshapes = #()

  ---SECTION 2 - DEFINE LOCAL FUNCTIONS---
  fn DYNFUNdrapeSplines FUNshapes FUNsurface FUNtype FUNlevel =
  (
    if FUNtype == 1 then
    (
      if isValidNode FUNsurface then
      (
        for a in FUNshapes do
        (
          if isValidNode a then
          (
            for i = 1 to (numSplines a) do
            (
              for ii = 1 to (numKnots a i) do
              (
                local LOCknt = getKnotPoint a i ii
                local LOCray = intersectRay LOCsurface (ray [LOCknt.x,LOCknt.y,9999.000] [0,0,-1])
                if LOCray != undefined then (try (setKnotPoint a i ii [LOCknt.x, LOCknt.y, LOCray.pos.z + FUNlevel]) catch ())
              )
            )
            updateShape a
          )
        )
      )
      else (messagebox (DYNuiResourcesErrorsWarnings[43]) title:DYNuiResourcesTitlebars[2])
    )
    else
    (
      for a in FUNshapes do
      (
        if isValidNode a then
        (
          for i = 1 to (numSplines a) do
          (
            for ii = 1 to (numKnots a i) do
            (
              local LOCknt = getKnotPoint a i ii
              try (setKnotPoint a i ii [LOCknt.x, LOCknt.y, FUNlevel]) catch ()
            )
          )
          updateShape a
        )
      )
    )
  )

  ---SECTION 3 - DEFINE PANEL LAYOUT---
  groupBox GBDYNgroup00        pos:[11,7]    width:258 height:55
  radiobuttons RBDYNstyle      pos:[20,24]   labels:#(DYNuiResourcesLabels[330], DYNuiResourcesLabels[331])

  groupBox GBDYNgroup01        pos:[11,68]   width:258 height:190
  multilistBox MLDYNobjectList pos:[20,85]   width:239 height:8
  pickbutton PKDYNshapes       pos:[20,202]  width:239 filter:DYNFUNsplineShapeFilter
  button BUDYNshapes           pos:[20,227]  width:239

  groupBox GBDYNgroup02        pos:[11,264]  width:258 height:95

  pickbutton PKDYNsurface      pos:[20,281]  width:239 filter:DYNFUNgeometryFilter
  edittext EDDYNsurface        pos:[20,306]  width:239
  label LBDYNlevel             pos:[20,335]  width:175
  spinner SPDYNlevel ""        pos:[187,334] range:[-999.0,999.0,0.0] fieldwidth:60 type:#float

  button BUDYNokok             pos:[11,368]  width:72 height:22
  button BUDYNapply            pos:[104,368] width:72 height:22
  button BUDYNcanc             pos:[197,368] width:72 height:22

  ---SECTION 4 - DEFINE PANEL ACTIONS---
  on DYNdrapeSpline open do
  (
    DYNdrapeSpline.title  = DYNuiRolloutNames[35]

    GBDYNgroup00.text     = DYNuiResourcesGroups[98]
    GBDYNgroup01.text     = DYNuiResourcesGroups[99]
    GBDYNgroup02.text     = DYNuiResourcesGroups[100]

    LBDYNlevel.text       = DYNuiResourcesLabels[329]

    BUDYNokok.text        = DYNuiResourcesButtons[1]
    BUDYNapply.text       = DYNuiResourcesButtons[2]
    BUDYNcanc.text        = DYNuiResourcesButtons[3]
    PKDYNshapes.text      = DYNuiResourcesButtons[64]
    BUDYNshapes.text      = DYNuiResourcesButtons[65]
    PKDYNsurface.text     = DYNuiResourcesButtons[63]
    EDDYNsurface.readOnly = true
  )

  on DYNdrapeSpline close do
  (
    DYNFUNonDialogClose()
  )

  on RBDYNstyle changed arg do
  (
    if arg == 1 then
    (
      PKDYNsurface.enabled = true
    )
    else
    (
      PKDYNsurface.enabled = false
      LOCsurface = undefined
      EDDYNsurface.text = ""
    )
  )

  on BUDYNshapes pressed do
  (
    local LOCselArray = selectByName title:DYNuiResourcesTitlebars[29] buttonText:DYNuiResourcesButtons[72] filter:DYNFUNsplineShapeFilter showHidden:false single:false

    if LOCselArray != undefined then
    (
      for i in LOCselArray do (if isValidNode i then append LOCshapes i)

      local LOCshapeNames = #()
      if LOCshapes.count > 0 then
      (
        for i in LOCshapes do
        (
          append LOCshapeNames i.name
        )
        MLDYNobjectList.items = LOCshapeNames
      )
    )
  )

  on PKDYNshapes picked arg do
  (
    if isValidNode arg then
    (
      append LOCshapes arg

      local LOCshapeNames = #()
      for i in LOCshapes do
      (
        append LOCshapeNames i.name
      )
      MLDYNobjectList.items = LOCshapeNames
    )
  )

  on PKDYNsurface picked arg do (if isValidNode arg then (LOCsurface = arg; EDDYNsurface.text = arg.name))

  on BUDYNokok  pressed do (DYNFUNdrapeSplines LOCshapes LOCsurface RBDYNstyle.state SPDYNlevel.value; destroyDialog DYNdrapeSpline)
  on BUDYNapply pressed do (DYNFUNdrapeSplines LOCshapes LOCsurface RBDYNstyle.state SPDYNlevel.value)
  on BUDYNcanc  pressed do (destroyDialog DYNdrapeSpline)
)
